.ifndef __MAPS_ENGINE_ASM__
.define __MAPS_ENGINE_ASM__

;c: line
;destroys everything
.section "gameplayMapsEngine.loadLine" free
gameplayMapsEngine.loadLine:
	ld hl, vramRaw.haveData
	ld (hl), 1
	inc c	;adjust the line, now 0 is the one to be loaded on $3800
	res 5, c
	ld a, c
	inc l
	ex de, hl
	
	;calculate the Vram address to the line
	add a, 2
	and %00011111
	rla
	rla
	rla
	ld l, a
	ld h, 0
	add hl, hl
	add hl, hl
	add hl, hl
	ld a, VramWrite.hi | $37
	add a, h
	cp VramWrite.hi | $3f
	jr c, +
		sub $3f - $37
+:	
	ex de, hl
	ld (hl), e
	inc l
	ld (hl), a
	inc l
	
	ld (hl), <endSeqOuti-128
	inc l
	ld (hl), >(endSeqOuti - 128)
	inc l; vramRaw.buffer
	push hl	;saves vramRaw.buffer on the stack
	
	;load the first metatile address and the line number
	ld hl, (scroll.higher - 1) 	
	ld l, c	
teste14:
	xor a
	srl l
	;load least significant bit of the line to a, this indicates witch bytes of the meta tile will be loaded.
	rra
	rlca
	
	ld bc, $10ff

-:		ld e, (hl)
		ld d, >metaTiles >> 3
		ex (sp), hl
		ex de, hl
		add hl, hl
		add hl, hl
		add hl, hl	
		
		or a
		jr nz, +
			ldi
			ldi
+:		
		inc l
		inc l
		ldi
		ldi
		inc l
		inc l
	
		or a
		jr z, +
			ldi
			ldi
			
+:			
		ex de, hl
		ex (sp), hl
		ld e, a
		ld a, 16
		add a, l
		ld l, a
		ld a, e
		teste15:
	djnz -
	
	pop de
	ret
.ends

;bc: movement 
.section "gameplayMapsEngine.horizontalScrollLeft" free
gameplayMapsEngine.horizontalScrollLeft:
	ld hl, (horizontalScroll)
	ld a, h
	add hl, bc
	ld (horizontalScroll), hl 
	rl e	;save carry flag on e:0
	
	ld b, h		;save new scroll.hi position
	xor h
	and %11111000 ; this is made to compare if there were any change that could trigger an new column.
	ret z 
		ld hl, scroll.higher
		ld d, (hl)
		rr e		;if a is odd after ored with e, than its time to upgrade scroll.higher
		jp c, ++
			ld a, (limits.beginning)
			sub d
			jp nz, +
				dec l		;if we get here, than it's the end of the room and therefore, there is no need to load another a column
							;ld hl, horizontalScroll + 1
				ld (hl), a
				dec l
				ld (hl), a
				ret
+:			dec (hl)	
++:		
		ld h, d
		ld a, b
		add a, 8
		ld b, a
		jp gameplayMapsEngine.loadColumn
.ends

;\1: is a odd column
;\2: 1 if is just the second half of the metatile to load, 2 if is the secound half, 3 if is all
;\hl: address of the meta tile
;\(sp): address in the column buffer
.macro gameplayMapsEngine.loadColumMetatile 
	ld e, (hl)
	ld d, >metaTiles >> 3

	ex (sp), hl
	ex de, hl
	add hl, hl
	.if \1 == 1
		inc l
	.endif
	add hl, hl
	add hl, hl
	.if \2 & 2 != 0
		ldi
		ldi
	.else
		inc l 
		inc l
	.endif
	.if \2 & 1 != 0
		ldi
		ldi
	.else
		inc l 
		inc l
	.endif
	
	ex de, hl
	ex (sp), hl
	inc l
.endm

;bc: movement
.section "gameplayMapsEngine.horizontalScrollRight" free
gameplayMapsEngine.horizontalScrollRight:
	ld a, (limits.ending)
	ld hl, scroll.higher
	cp (hl)
	ret z	;if we are here, than we already in the end of the room, so, no scroll will occur
	
	ld hl, (horizontalScroll)
	ld a, h
	add hl, bc
	ld (horizontalScroll), hl 
	rl e	;save carry flag on e:0
	
	ld b, h		;save new scroll.hi position
	xor h
	and %11111000 ; this is made to compare if there were any change that could trigger an new column.
	ret z 
		ld hl, scroll.higher
		rr e		;if a is odd after ored with e, than its time to upgrade scroll.higher
		jp nc, +
			inc (hl)	;inc scroll
			ld h, (hl)
			ld a, (limits.ending)
			sub h
			jp nz, ++
				ld hl, horizontalScroll
						;if we get here, than it's the end of the room and therefore, there is no need to load another a column
						;ld hl, horizontalScroll + 1
				ld (hl), a
				inc l
				ld (hl), a
				ret
+:			ld h, (hl)		
++:		
		inc h	;get the most significant part of the metaTile's address, based on the most significant part of the scroll
				;its incremented by one because the scroll position indicates the first column on the left 
	
gameplayMapsEngine.loadColumn:
	
	ld de, column.hasNewColumn
	ld a, 1
	ld (de), a
	inc e
	ld a, b
	and %11111000
	ld l, a
	res 3, l		;get the least significant part of the metaTile's address
	
	rrca
	rrca
	rrca
	ld (de), a
	inc e
	
	push de
	rra
	jr nc, gameplayMapsEngine.loadEvenColumnBuffer
	
gameplayMapsEngine.loadOddColumnBuffer:	
	gameplayMapsEngine.loadColumMetatile 1 1
	ld bc, (13 << 8) | $ff
-:		
		gameplayMapsEngine.loadColumMetatile 1 3
	djnz -
	gameplayMapsEngine.loadColumMetatile 1 2
	pop de
	ret
	
gameplayMapsEngine.loadEvenColumnBuffer:	
	gameplayMapsEngine.loadColumMetatile 0 1
	ld bc, (13 << 8) | $ff
-:		
		gameplayMapsEngine.loadColumMetatile 0 3
	djnz -
	gameplayMapsEngine.loadColumMetatile 0 2
	pop de
	ret
.ends


.section "gameplayMapsEngine.loadScrollingRight" free
gameplayMapsEngine.loadScrollingRight:
	ld a, (limits.orientation)
	push af
	call gameplayMapsEngine.processTransition
	pop de	;restore previous orientation
	ld a, (limits.orientation)
	or d
	rra
	jr c, +	
	;since neither of the maps involved in the transation have the leftmost column hided,
	;we go for a less smooth transition in that way.
		ld b, 32
-:			push bc
			ld hl, (scroll.higher - 1)
			push hl	
			ld b, l
			call gameplayMapsEngine.loadColumn
			pop hl
			ld a, 8
			add a, l
			ld l, a
			ld (scroll.higher - 1), hl
			call prepareForVblank
			call prepareForVblank
			pop bc
		djnz -
		ret
	
+:	;if that is the case, than at least one of the maps involved in the transition had the left column hided
	; so, we go for a more smooth transition in that way.
	
		ld hl, (scroll.higher - 1)
		push hl	
			ld b, l
			call gameplayMapsEngine.loadColumn
		pop af
		dec a
		ld (scroll.higher), a

		ld hl, vdpMisc1Value
		set BitM1HideLeftColoum, (hl)
	
		ld b, 64
	-:		push bc
			ld bc, $0400
			call gameplayMapsEngine.horizontalScrollRight
			call prepareForVblank
			pop bc
		djnz -
		ld a, (limits.orientation)
		rra

	jr c, +	
		;It will load columns 1-32, so, if we will show the leftmost column, than
		;its necessary to load the 0 column again
		ld hl, vdpMisc1Value
		res BitM1HideLeftColoum, (hl)

		ld hl, (scroll.higher - 1)
		ld b, l
		jp gameplayMapsEngine.loadColumn
+	;horizontalOrientation
	ret
.ends

;b: number of lines to load
;c: first lines to load
;l: 1 for scrolling down, -1 for scrolling up
;h: 1 if the lines are already preloaded, 2 if is to load the lines without scrolling
;de and hl will not be destroyed
.section "gameplayMapsEngine.verticalScroll" free
gameplayMapsEngine.verticalScroll:
--:		push bc
		push hl
		
		dec h
		jr z, +
			push de
			push hl
			call gameplayMapsEngine.loadLine		
			pop hl
			pop de
+:		dec h
		ld b, 1
		jr z, ++
			pop hl
			push hl		;peek the incrementer from the top of the stack
			
			ld b, $02
			add hl, hl
			add hl, hl

	-:			ld a, (verticalScroll+1)
				add a, l
				cp d
				jr nz, +
					ld a, e
	+:			ld (verticalScroll+1), a
++:				push hl
				push de		;save scrollLimits
				push bc
				call prepareForVblank
				pop bc
				pop de
				pop hl
			djnz -	
	
		pop hl
		pop bc
		ld a, c
		add a, l
		;and %00011111
		ld c, a
	djnz --	
	ret
.ends

;h: 1 if the lines are already preloaded, 2 if is to load the lines without scrolling
;de and hl will not be destroyed
.section "gameplayMapsEngine.preLoadScrollDown" free
gameplayMapsEngine.preLoadScrollDown:
	ld a, (resolutionDependencies.verticalScrollEnd)
	ld d, a
	ld e, 0
	ld bc, (resolutionDependencies.preLoadScrollDown)
gameplayMapsEngine.posLoadScrollDown:	
	ld l, 1
	jp gameplayMapsEngine.verticalScroll
.ends

;hl: pointer to the transition
.section "gameplayMapsEngine.scrollDown" free
gameplayMapsEngine.scrollDown:
	ld a, (limits.ending)
	ld hl, scroll.higher
	sub (hl)
	jr nz, gameplayMapsEngine.scrollDownNoTransiontion
		ld l, <endingTransitions.bottom + 1 	;ignore the higher scroll where the transition should happen since it will
										; be here for certain. That information is only usefull for horizontal oriented maps.
		add a, (hl)
		ret z
			ld d, a
			dec l
			ld e, (hl)
			ex de, hl
gameplayMapsEngine.loadScrollingDown:
			push hl
			call gameplayMapsEngine.preAdjust32ColumnVerticalTransition
	
			ld h, 2
			call gameplayMapsEngine.preLoadScrollDown
	
			pop hl
			call gameplayMapsEngine.processTransition
		
			ld h, 1
			call gameplayMapsEngine.preLoadScrollDown
			
			jr +
			
gameplayMapsEngine.scrollDownNoTransiontion:	
	;h will be loaded with something else than 1 or 2
	call gameplayMapsEngine.preLoadScrollDown
	ld hl, scroll.higher
	inc (hl)

+:	ld bc, (resolutionDependencies.posLoadScrollDown)
	dec h
	call gameplayMapsEngine.posLoadScrollDown
	jp gameplayMapsEngine.posAdjust32ColumnVerticalTransition	

.ends

;h: 1 if the lines are already preloaded, 2 if is to load the lines without scrolling
;de and hl will not be destroyed
.section "gameplayMapsEngine.preLoadScrollUp" free
gameplayMapsEngine.preLoadScrollUp:	
	ld bc, (resolutionDependencies.preLoadScrollUp)
	ld a, (resolutionDependencies.verticalScrollEnd)
	ld e, a
	ld d, 0
gameplayMapsEngine.posLoadScrollUp:	
	ld l, -1
	jp gameplayMapsEngine.verticalScroll
.ends

;hl: pointer to the transition
.section "gameplayMapsEngine.scrollUp" free
gameplayMapsEngine.scrollUp:
	ld a, (limits.beginning)
	ld hl, scroll.higher
	sub (hl)
	jr nz, gameplayMapsEngine.scrollUpNoTransiontion
		ld l, <beginningTransitions.top + 1	
		
		add a, (hl)
		ret z
			ld d, a
			dec l
			ld e, (hl)
			ex de, hl
gameplayMapsEngine.loadScrollingUp:			
			push hl
			call gameplayMapsEngine.preAdjust32ColumnVerticalTransition
			
			ld h, 2
			call gameplayMapsEngine.preLoadScrollUp
	
			pop hl
			call gameplayMapsEngine.processTransition
		
			ld h, 1
			call gameplayMapsEngine.preLoadScrollUp
			
			jr +
			
gameplayMapsEngine.scrollUpNoTransiontion:	
	
	call gameplayMapsEngine.preLoadScrollUp
	ld hl, scroll.higher
	dec (hl)
+:
	ld bc, (resolutionDependencies.posLoadScrollUp)
	dec h
	call gameplayMapsEngine.posLoadScrollUp
	jp gameplayMapsEngine.posAdjust32ColumnVerticalTransition

.ends

;hl: pointer to the transition
.section "gameplayMapsEngine.loadDireclty" free
gameplayMapsEngine.loadDireclty:
	call gameplayMapsEngine.processTransition
	ld hl, (scroll.higher - 1)
	ld c, 0
-:		push bc
		call gameplayMapsEngine.loadLine
		ld hl, vramRaw.destination
		call outputRawData
		pop bc
		inc c
		ld a, 28
		cp c
	jr nz, -
	call gameplayMapsEngine.posAdjust32ColumnVerticalTransition
	jp turnOnVdp
.ends

.section "gameplayMapsEngine.preAdjust32ColumnVerticalTransition" free
gameplayMapsEngine.preAdjust32ColumnVerticalTransition:
	ld hl, vdpMisc1Value
	res BitM1HideLeftColoum, (hl)

	ld hl, (scroll.higher - 1)
	ld b, l
	jp gameplayMapsEngine.loadColumn
.ends

.section "gameplayMapsEngine.posAdjust32ColumnVerticalTransition" free
gameplayMapsEngine.posAdjust32ColumnVerticalTransition:
	ld a, (limits.orientation)
	rra
	jp nc, +
;horizontalOrientation	
		ld hl, vdpMisc1Value
		set BitM1HideLeftColoum, (hl)
		ld hl, (scroll.higher - 1)
		inc h
		ld b, l
		jp gameplayMapsEngine.loadColumn
+:;vertical or no orientarion
			ld hl, vdpMisc1Value
			res BitM1HideLeftColoum, (hl)
	ret
.ends


;hl: poiter to the palette
.section "gameplayMapsEngine.loadPalette" free
gameplayMapsEngine.loadPalette:
	push af
	ld de, palette.hasNewPalette
	ld a, 1
	ld (de), a
	inc e
gameplayMapsEngine.loadPalette.mainLoop:
		ld a, (hl)
		cp %01000000	;if the last two bits are cleared
		jr c, gameplayMapsEngine.loadPalette.loadRegularEntry
		cp PaletteEndingMark
		jr nc, gameplayMapsEngine.loadPalette.loadLastEntry
		cp PaletteAnimationMark
		jr nc, gameplayMapsEngine.loadPalette.loadAnimation
		
;new outputAddress		
		and %00111111
		add a, <palette.buffer
		ld e, a
		inc hl
	jr gameplayMapsEngine.loadPalette.mainLoop			
		
gameplayMapsEngine.loadPalette.loadAnimation:
		and %00111111
		ld c, a
		ld b, a
		ld (paletteAnimation.framesPerFrame), bc
		inc hl
		jr z, gameplayMapsEngine.loadPalette.mainLoop
		
		ld a, (hl)
		ld b, a
		and %11110000
		rra
		rra
		rra
		rra
		ld c, a		; c: number of frames
		ld a, b
		and %00001111
		ld b, a		; b:entries per frame
		ld (paletteAnimation.entriesPerFrame), a
		push de ;save the buffer address

		ld a, e
		ld de, paletteAnimation.bufferPosition
		ld (de), a
		
		ld a, <paletteAnimation.buffer
		inc e  ; paletteAnimation.startOfNextFrame
		ld (de), a
		
		inc e ; paletteAnimation.buffer
		inc hl	;next colors
gameplayMapsEngine.loadPalette.loadAnimationOuterLoop:
			push bc
gameplayMapsEngine.loadPalette.loadAnimationInnerLoop:
				ldi
				inc bc
			djnz gameplayMapsEngine.loadPalette.loadAnimationInnerLoop
			pop bc
			dec c
		jr nz , gameplayMapsEngine.loadPalette.loadAnimationOuterLoop
		
		ld a, PaletteAnimationEndMark   ; end of animation mark
		ld (de), a
		
		;remove the eventual ending mark in the last entry of animation
		dec de
		ld a, (de)	
		and %00111111
		ld (de), a
		
		;prepare the buffer to copy the last frame of animation to,
		;the last frame of palette animation will be copied as a regular palette
		ld a, (paletteAnimation.entriesPerFrame)
		ld e, a
		ld d, 0
		or a
		sbc hl, de
		
		;restore buffer
		pop de
	jr gameplayMapsEngine.loadPalette.mainLoop
		
gameplayMapsEngine.loadPalette.loadRegularEntry:		
		ldi
	jr gameplayMapsEngine.loadPalette.mainLoop

gameplayMapsEngine.loadPalette.loadLastEntry ;last entry	
	and %00111111
	ld (de), a
	inc hl
	pop af
	ret
.ends

;de: pointer to the transitions addresses
.macro gemeplayMapsEngine.clearNextTransiotionAddress
	push af
	ld b, 12
	xor a
-:		ld (de), a
		inc e
	djnz -	
	pop af
.endm


;de: pointer to the destination of the descriptor
;hl: pointer to a 3 byte transition descriptor (subroom where the transion might occur, pointer to the transiotion)
.section "gemeplayMapsEngine.loadNextTransiotionAddress" free
gemeplayMapsEngine.loadNextTransiotionAddress:
	push af
	
	ld a, (hl)
	inc hl
	
	ld b, a
	set 6, b
	res 7, b	;adjust most significant part of the transiotion adderss
	
	and %11000000
	cp %11000000
	jr z, +
		rlca		;get the two most significan bits, if they are between 0-2, than it's only one transition
		rlca		
		rlca
		
		add a, e
		ld e, a
		ldi
		inc bc
		ld a, b
		
		ld (de), a
		pop af
	ret
	
+:	;two or three transitions			
		ld c, (hl)
		inc hl
		
		ld a, (hl)
		rlca
		rlca
		ld ixl, 3
-:			dec a
			jr nz, +
			inc e
			inc e
			dec ixl
		jr nz, -
+:			ex de, hl
			ld (hl), c
			inc l
			ld (hl), b
			inc l
			ex de, hl
			
			ld b, (hl)
			res 7, b
			set 6, b
			inc hl
			ld c, (hl)
			inc hl
			dec ixl
		jr nz, -
		dec hl
		dec hl
	pop af
	ret
.ends

;loads the limits of the room, the orientation of the room and initial scroll position
;hl: pointer to the limits, if they are vertical limits, than the first value will be complemented
.macro loadRoomLimits
teste8:	
	ld de, limits.orientation
	ld a, (hl)
	inc l
	ld c, a
	
	;the most significant bits on the first limit, are the indicator of the orinetation of the room
	ld b, 0
	rla
	rl b
	rla
	rl b

	ld a, b
	ld (de), a
	
	ld a, c
	or %11000000
	ld (scroll.higher), a
	inc e
	ld (de), a
	inc e
	ld (de), a
	
	dec b
	ret m	;if so, than we are done 
	
	cp (hl)		;check if the scrolls are reverted
	jr c, loadRoomlimits.scrollsNotReverted		;if that, than the ending limit is first in memory, so the scenario will be loaded
		dec e
loadRoomlimits.scrollsNotReverted:
	ldi	;limits.ending <- second limit
	
.endm

;ld hl: pointer to the pointer to the map
.macro loadGameplayMap
	push af
	ld a, (stage.compressedMapsBank)
	ld (MapperSlot2), a
	
	ld e, (hl)
	inc hl
	ld d, (hl)
	inc hl
	
	push hl
	ex de, hl
	ld de, gameplayMap
	call aplibDepack
	pop hl
	pop af
.endm

;returns:
;ix: tiles address in ROM
.macro loadTiles
	ld a, (hl)
	inc hl
	ld (MapperSlot2), a
	ld b, (hl)	;load tiles origin pointer
	ld ixl, b
	inc hl
	ld b, (hl)
	ld ixh, b
	inc hl
	
	ld b, (hl);	load tiles counter
	inc hl
	
	ld e, (hl); load destination pointer
	inc hl
	ld d, (hl)
	inc hl
	push hl
	ex de, hl
	call decompressBTiles
	pop hl
.endm

.macro gameplayMapsEngine.checkForTransitionToHor args noTransition
	ld a, (scroll.higher)
	ld hl, limits.ending
	cp (hl)
	jp nz, gameplayMapsEngine.checkForTransitionToHor.beginning.\@ 
		xor a
		ld l, <endingTransitions.right + 1
		add a, (hl)
		jp z, noTransition
			dec l
			ld l, (hl)
			ld h, a
			jr gameplayMapsEngine.checkForTransitionToHor.end.\@
gameplayMapsEngine.checkForTransitionToHor.beginning.\@:	
	dec l ;limits.beginning
	sub a
	jp nz, noTransition
		ld l, <beginningTransitions.right + 1
		add a, (hl)
		jp z, noTransition
			dec l
			ld l, (hl)
			ld h, a
gameplayMapsEngine.checkForTransitionToHor.end.\@:			
.endm

.macro gameplayMapsEngine.checkForTransitionToVer args noTransition, isTop
	ld a, (scroll.higher)
	ld hl, limits.ending
	cp (hl)
	jp nz, gameplayMapsEngine.checkForTransitionToVer.beginning.\@ 
		xor a
		ld l, <endingTransitions.bottom + isTop*2 + 1
		add a, (hl)
		jp z, noTransition
			dec l
			ld l, (hl)
			ld h, a
			jr gameplayMapsEngine.checkForTransitionToVer.end.\@
gameplayMapsEngine.checkForTransitionToVer.beginning.\@:	
	dec l ;ld l, <limits.beginning
	sub a
	jr nz, noTransition
		ld l, <horizontalScroll
		or (hl)
		jp nz, noTransition
			ld l, <beginningTransitions.bottom + isTop*2 + 1
			add a, (hl)
			jp z, noTransition
				dec l
				ld l, (hl)
				ld h, a
gameplayMapsEngine.checkForTransitionToVer.end.\@:			
.endm

.macro gameplayMapsEngine.getSpeed
	ld a, b

	ld bc, \1 * MegamanWalkingSpeed
	bit BitBKey, a
	jr z, gameplayMapsEngine.getSpeed.testC.\@
		sla c
		rl b
gameplayMapsEngine.getSpeed.testC.\@:
	bit BitCKey, a
	jr z, gameplayMapsEngine.getSpeed.end.\@
		sla c
		rl b
gameplayMapsEngine.getSpeed.end.\@:

	/*.if \1 == -1
		ld h, b
		ld l, c
		or a
		sbc hl, bc
		or a
		sbc hl, bc
		ld b, h
		ld c, l
	
	.endif
*/
.endm 


.section "gameplayMapsEngine.navigate" free
gameplayMapsEngine.navigate:
	call gameplayMapsEngine.loadStage
	call clearSpriteTable
	call turnOnVdp
	call prepareForVblank
-:		
		ld a, (pressedKeys)
		bit BitStartKey, a
		jr z, +
			jp PSGStop	;call + ret
+:	
		ld a, (limits.orientation)
		rra 
		jr c, horizontalOrientationGameplay
		;rra
		;jr c, verticalOrientationGameplay
verticalOrientationGameplay:
			ld a, (pressedKeys)
			and UKey | DKey | RKey
			jp z, +++
			and UKey | DKey
			jr z, ++
			and UKey
			jr z, +
			;UKey
			teste22:
				call gameplayMapsEngine.scrollUp
			jp +++	
+:			;DKey
				call gameplayMapsEngine.scrollDown
			jp +++	
++:			;RKey
				gameplayMapsEngine.checkForTransitionToHor +++
				call gameplayMapsEngine.loadScrollingRight
			jp +++

horizontalOrientationGameplay:
		ld a, (holdedKeys)
		ld b, a
		and RKey | LKey
		jr z, horizontalOrientationCheckTransition
		and RKey
		jr z, +
			gameplayMapsEngine.getSpeed 1
			call gameplayMapsEngine.horizontalScrollRight
			jp horizontalOrientationCheckTransition
+:		;Lkey
			gameplayMapsEngine.getSpeed -1
			call gameplayMapsEngine.horizontalScrollLeft
horizontalOrientationCheckTransition:
			ld a, (pressedKeys)
			and UKey | DKey | RKey
			jp z, +++
			and UKey | DKey
			jr z, ++
			and UKey
			jr z, +
			;UKey
			teste20:
				gameplayMapsEngine.checkForTransitionToVer +++, 1
				call gameplayMapsEngine.loadScrollingUp
			jr +++	
+:			;DKey
teste21:
				gameplayMapsEngine.checkForTransitionToVer +++, 0
				call gameplayMapsEngine.loadScrollingDown
			jr +++	
++:			;RKey
				gameplayMapsEngine.checkForTransitionToHor +++
				call gameplayMapsEngine.loadScrollingRight				
+++:		
		call prepareForVblank
	jp -
.ends


;process a transition to a new area in a stage
;hl:  address to the transition attributes
;returns
;mapperPage1: page of the tiles
;all maps related stuff loaded in theirs respective addresses.
.section "gameplayMapsEngine.processTransition" free
gameplayMapsEngine.processTransition:
	ld a, (stage.bank)
	ld (MapperSlot1), a
	ld a, (hl)  ;loading transiction flags 
				
	rla
	jr nc, +; indicates if this loaded room is a checkpoint
		ld (checkpoint), hl
+:	inc hl
	
	rla
	jr nc, +;indicates if is necessary to load a new palette
		call gameplayMapsEngine.loadPalette
		
+:	ld de, beginningTransitions.bottom
	push de
	gemeplayMapsEngine.clearNextTransiotionAddress
	pop de

	rla
	jr nc, +;indicates if there is a top transition for this room
		call gemeplayMapsEngine.loadNextTransiotionAddress
+:	
	ld e, <endingTransitions.bottom
	rla
	jr nc, +;indicates if there is a bottom transition for this room
		call gemeplayMapsEngine.loadNextTransiotionAddress

+:	rla
	jr nc, +;indicates if there is a new gameplayMap to load into memory
		loadGameplayMap

+:	rla
	jr nc, +; indicates if is necesary to load new tiles
		loadTiles
+:	
loadRoomLimits:	
	loadRoomLimits
	
	ld a, 1
	ld (MapperSlot1), a
	ret
.ends



; loads stuff related to a entire stage:
;	scenario palettes, gameplayMap tiles
;	and first room transition
; hl:	pointer to the structure
.section "gameplayMapsEngine.loadStage" free
gameplayMapsEngine.loadStage:
	call turnOffVdp
	ld a, (stage.bank)
	ld (MapperSlot1), a
	ld hl, (stage.loader)
	
	ld a, (hl)	;load BankTilesNumber
	inc hl
	ld c, (hl)	;load TileCounter
	inc hl
	ld b, 0
	
	ld e, (hl)	;load TilesPointer
	inc hl
	ld d, (hl)
	inc hl
	push hl
	ld ixl, e
	ld ixh, d

	ld hl, ($3700 | VramWrite) >> 5	;calculate destination addr on Vram
	or a
	sbc hl, bc
	.rept 5
		add hl, hl
	.endr
	ld (MapperSlot2), a
	
	ld b, c
	call decompressBTiles		;decompress Scenario Tiles
	pop hl

teste9:	
	ld a, (hl)	;load tilemapBankNumber
	inc hl
	
	ld e, (hl)	;load tilemapNumber
	inc hl
	ld d, (hl)
	inc hl
	push hl
	ex de, hl
	
	ld (MapperSlot2), a
	ld c, (hl)	;load tilemap offset
	inc hl
	ld b, (hl)
	inc hl
	push bc
	ld de, metaTiles
	push de
	call aplibDepack
	
	pop hl	;pop metaTiles
	pop de	;pop offset
	ld bc, 4
teste11:	
-:			ld a, (hl)
			add a, e
			ld (hl), a
			inc hl
			ld a, (hl)
			adc a, d
			ld (hl), a
			inc hl
			inc de
		djnz -
		dec c
	jr nz, -	
		
	pop hl

	ld a, (hl)
	ld (stage.compressedMapsBank), a
	inc hl
	
	call gameplayMapsEngine.loadDireclty
	
	ld a, :bubblemanMusic
	ld hl, bubblemanMusic
	call PSGPlay
	
	jp turnOnVdp
	
.ends


.endif